
@ECHO OFF
SETLOCAL


REM		Batch script for building FreeGLUT via Borland C++ Compiler v5.5.1.
REM
REM		Copyright (c) 2024 skipper
REM		http://www.heroesden.link


REM	****************************************************************************
REM
REM		BUILDING CONFIGURATION.
REM
REM		This is configurable section, here you need to set up path to "bin"
REM		directory of Borland's command line tools.
REM
REM		Also you can change building targets. To enable a target, change value
REM		of associated variable to 1. To disable a target, switch it value to 0.
REM
REM		List of targets:
REM
REM			BUILD_LIB_DEBUG			- debugging static library.
REM
REM			BUILD_LIB_RELEASE		- release static library.
REM
REM			BUILD_DLL_DEBUG			- debugging dynamic link library (DLL).
REM
REM			BUILD_DLL_RELEASE		- release dynamic link library (DLL).
REM
REM			BUILD_DEMO_LIB_DEBUG	- debugging demo applications with static
REM									library linkage.
REM
REM			BUILD_DEMO_LIB_RELEASE	- release demo applications with static
REM									library linkage.
REM
REM			BUILD_DEMO_DLL_DEBUG	- debugging demo applications with DLL
REM									linkage.
REM
REM			BUILD_DEMO_DLL_RELEASE	- release demo applications with DLL
REM									linkage.
REM
REM	****************************************************************************


SET $BIN=C:\Borland\BCC55\bin

SET $BUILD_LIB_DEBUG=1
SET $BUILD_LIB_RELEASE=1

SET $BUILD_DLL_DEBUG=1
SET $BUILD_DLL_RELEASE=1

SET $BUILD_DEMO_LIB_DEBUG=1
SET $BUILD_DEMO_LIB_RELEASE=1

SET $BUILD_DEMO_DLL_DEBUG=1
SET $BUILD_DEMO_DLL_RELEASE=1


REM	****************************************************************************
REM
REM		Hello notes.
REM
REM	****************************************************************************


IF /I NOT "%1" == "-q" (

	ECHO(
	ECHO ***********************************************************************
	ECHO *                                                                     *
	ECHO *    You are running unofficial batch script for building FreeGLUT    *
	ECHO *    library via Borland C++ Compiler v.5.5.1. Before building the    *
	ECHO *    library, please, read the instruction in "readme_src.txt" file,  *
	ECHO *    copyright notice in "copyright_freeglut.txt" file and license    *
	ECHO *    agreement in "copyright_hden.txt" file.                          *
	ECHO *                                                                     *
	ECHO *    To skip this note in the future and automatically accept the     *
	ECHO *    license agreement you may run the batch script with "-q" option. *
	ECHO *                                                                     *
	ECHO *    Unofficial FreeGLUT builds on https://www.heroesden.link/.       *
	ECHO *    Email address for any questions, complaints or suggestions:      *
	ECHO *    mailbox@heroesden.link.                                          *
	ECHO *                                                                     *
	ECHO ***********************************************************************
	ECHO(

	ECHO Do you accept terms of the Light license agreement?
	ECHO(

	SETLOCAL EnableDelayedExpansion
	SET /P "$AGREE=(enter 'y' to agree or anything else to disagree): "

	IF /I NOT "!$AGREE: =!" == "y" (
		ECHO(
		ECHO Building was terminated.
		EXIT /B
	)
	SETLOCAL DisableDelayedExpansion
)


ECHO(
ECHO --- Checking installation of command line tools...
ECHO(


IF NOT EXIST "%$BIN%\bcc32.exe" (
	ECHO Error: bcc32.exe was not found in $BIN directory. You need to download
	ECHO        and install Borland C++ Compiler 5.5.1 with command line tools,
	ECHO        then create and set up "bcc32.cfg" and "ilink32.cfg"
	ECHO        configuration files according to Borland's documentation.
	ECHO(
	ECHO        Afterwards $BIN variable in the batch script must be changed to
	ECHO        actual installation directory of the command line tools.
	EXIT /B
)

IF NOT EXIST "%$BIN%\bcc32.cfg" (
	ECHO Error: bcc32.cfg was not found in $BIN directory. You need to create
	ECHO        and set up compiler's configuration file in "bin" directory of
	ECHO        installed Borland's command line tools.
	EXIT /B
)

IF NOT EXIST "%$BIN%\ilink32.cfg" (
	ECHO Error: ilink32.cfg was not found in $BIN directory. You need to create
	ECHO        and set up linker's configuration file in "bin" directory of
	ECHO        installed Borland's command line tools.
	EXIT /B
)


REM	****************************************************************************
REM
REM		Compiling flags.
REM
REM		NOTE. Be careful with exclamation mark (!) in values of variables
REM		because	delayed expansion may be turned on below.
REM
REM ****************************************************************************


REM *** Common macroses needed for successfull compiling of the project.
REM
SET $DEFS_MAIN=-D_WIN32 -D_WIN32_WINNT=0x0500 -DWINVER=0x0500 -D_UNICODE ^
	-DUNICODE -DGLUT_DISABLE_ATEXIT_HACK -DFREEGLUT_LIB_PRAGMAS=0

REM *** Macro definitions for building static libraries and demo
REM *** applications.
REM
SET $DEFS_LIB_DEBUG=%$DEFS_MAIN% -DFREEGLUT_STATIC -D_DEBUG
SET $DEFS_LIB_RELEASE=%$DEFS_MAIN% -DFREEGLUT_STATIC -DNDEBUG

REM *** Macro definitions for building dynamic libraries and demo
REM *** applications.
REM
SET $DEFS_DLL_DEBUG=%$DEFS_MAIN% -DFREEGLUT_EXPORTS -D_DEBUG
SET $DEFS_DLL_RELEASE=%$DEFS_MAIN% -DFREEGLUT_EXPORTS -DNDEBUG

REM *** Bcc32 flags for compiling of static libraries.
REM
SET $CFLAGS_LIB_DEBUG=-q -c -w- -tWC -v -Od
SET $CFLAGS_LIB_RELEASE=-q -c -w- -tWC -v- -O2

REM *** Bcc32 flags for compiling of dynamic libraries.
REM
SET $CFLAGS_DLL_DEBUG=-q -c -w- -tWD -v -Od
SET $CFLAGS_DLL_RELEASE=-q -c -w- -tWD -v- -O2

REM *** Ilink32 flags for linking of dynamic libraries.
REM
SET $LFLAGS_DLL_DEBUG=-q -C -v -Tpd -Gi
SET $LFLAGS_DLL_RELEASE=-q -C -v- -Tpd -Gi

REM *** Ilink32 flags for linking of demo applications.
REM
SET $LFLAGS_DEMO_DEBUG=-q -C -v -Tpe -ap
SET $LFLAGS_DEMO_RELEASE=-q -C -v- -Tpe -ap

REM *** Filename of a Borland's startup module used by dynamic libraries.
REM
SET $DLL_STARTUP_MODULE=c0d32w.obj

REM *** Filename of a Borland's startup module used by demo applications.
REM
SET $DEMO_STARTUP_MODULE=c0x32w.obj

REM *** List of runtime and additional libraries for inclusion by the linker.
REM
SET $LINKER_LIBS=import32.lib cw32.lib


REM	****************************************************************************
REM
REM		Lists of files.
REM
REM ****************************************************************************


SET $SRC_FILES_ROOT= ^
	src\fg_callbacks.c ^
	src\fg_cursor.c ^
	src\fg_display.c ^
	src\fg_ext.c ^
	src\fg_font.c ^
	src\fg_font_data.c ^
	src\fg_gamemode.c ^
	src\fg_geometry.c ^
	src\fg_gl2.c ^
	src\fg_init.c ^
	src\fg_input_devices.c ^
	src\fg_joystick.c ^
	src\fg_main.c ^
	src\fg_menu.c ^
	src\fg_misc.c ^
	src\fg_overlay.c ^
	src\fg_spaceball.c ^
	src\fg_state.c ^
	src\fg_stroke_mono_roman.c ^
	src\fg_stroke_roman.c ^
	src\fg_structure.c ^
	src\fg_teapot.c ^
	src\fg_videoresize.c ^
	src\fg_window.c

SET $SRC_FILES_MSWIN= ^
	src\mswin\fg_cmap_mswin.c ^
	src\mswin\fg_cursor_mswin.c ^
	src\mswin\fg_display_mswin.c ^
	src\mswin\fg_ext_mswin.c ^
	src\mswin\fg_gamemode_mswin.c ^
	src\mswin\fg_init_mswin.c ^
	src\mswin\fg_input_devices_mswin.c ^
	src\mswin\fg_joystick_mswin.c ^
	src\mswin\fg_main_mswin.c ^
	src\mswin\fg_menu_mswin.c ^
	src\mswin\fg_spaceball_mswin.c ^
	src\mswin\fg_state_mswin.c ^
	src\mswin\fg_structure_mswin.c ^
	src\mswin\fg_window_mswin.c

SET $SRC_FILES_DEMO= ^
	src\demos\3dview\3dview.c ^
	src\demos\callback_maker\callback_maker.c ^
	src\demos\fractals\fractals.c ^
	src\demos\fractals_random\fractals_random.c ^
	src\demos\indexed_color\indexed_color.c ^
	src\demos\init_error_func\init_error_func.c ^
	src\demos\joystick\joystick.c ^
	src\demos\keyboard\keyboard.c ^
	src\demos\lorenz\lorenz.c ^
	src\demos\multi_touch\multi_touch.c ^
	src\demos\one\one.c ^
	src\demos\resizer\resizer.c ^
	src\demos\shapes\shapes.c ^
	src\demos\shapes\glmatrix.c ^
	src\demos\smooth_opengl3\smooth_opengl3.c ^
	src\demos\spaceball\spaceball.c ^
	src\demos\spaceball\vmath.c ^
	src\demos\subwin\subwin.c ^
	src\demos\timer\timer.c ^
	src\demos\timer_callback\timer_callback.c

SET $OBJ_FILES= ^
	fg_callbacks.obj ^
	mswin\fg_cmap_mswin.obj ^
	fg_cursor.obj ^
	mswin\fg_cursor_mswin.obj ^
	fg_display.obj ^
	mswin\fg_display_mswin.obj ^
	fg_ext.obj ^
	mswin\fg_ext_mswin.obj ^
	fg_font.obj ^
	fg_font_data.obj ^
	fg_gamemode.obj ^
	mswin\fg_gamemode_mswin.obj ^
	fg_geometry.obj ^
	fg_gl2.obj ^
	fg_init.obj ^
	mswin\fg_init_mswin.obj ^
	fg_input_devices.obj ^
	mswin\fg_input_devices_mswin.obj ^
	fg_joystick.obj ^
	mswin\fg_joystick_mswin.obj ^
	fg_main.obj ^
	mswin\fg_main_mswin.obj ^
	fg_menu.obj ^
	mswin\fg_menu_mswin.obj ^
	fg_misc.obj ^
	fg_overlay.obj ^
	fg_spaceball.obj ^
	mswin\fg_spaceball_mswin.obj ^
	fg_state.obj ^
	mswin\fg_state_mswin.obj ^
	fg_stroke_mono_roman.obj ^
	fg_stroke_roman.obj ^
	fg_structure.obj ^
	mswin\fg_structure_mswin.obj ^
	fg_teapot.obj ^
	fg_videoresize.obj ^
	fg_window.obj ^
	mswin\fg_window_mswin.obj ^
	util\xparsegeometry_repl.obj


REM The $DEMO_LINK_OBJ is a list of demo applications used by a linker. Each
REM string from the list has the following format:
REM
REM		application's name;
REM		list of additional OBJ files (just filenames without path);
REM		list of RES files (path to the file in "res" directory)
REM

SET $DEMO_LINK_OBJ= ^
	"3dview; ; " ^
	"callback_maker; ; " ^
	"fractals; ; " ^
	"fractals_random; ; " ^
	"indexed_color; ; " ^
	"init_error_func; ; " ^
	"joystick; ; " ^
	"keyboard; ; " ^
	"lorenz; ; " ^
	"multi_touch; ; " ^
	"one; ; res\one.res" ^
	"resizer; ; " ^
	"shapes; glmatrix.obj; " ^
	"smooth_opengl3; ; " ^
	"spaceball; vmath.obj; " ^
	"subwin; ; " ^
	"timer; ; " ^
	"timer_callback; ; "


REM	****************************************************************************
REM
REM		Create missed directories.
REM
REM ****************************************************************************


CALL prepare.bat


REM	****************************************************************************
REM
REM		Compile debugging static library.
REM
REM ****************************************************************************


ECHO(
<NUL SET /P $TMP=--- Building of debugging static library is

IF "%$BUILD_LIB_DEBUG: =%" == "1" (

	ECHO  RUNNING...
	ECHO(


	FOR %%G IN (
		"-nobjs\lib_debug\			%$SRC_FILES_ROOT%"
		"-nobjs\lib_debug\mswin\	%$SRC_FILES_MSWIN%"
		"-nobjs\lib_debug\util\		src\util\xparsegeometry_repl.c"
	) DO (
		"%$BIN%\bcc32.exe" %$CFLAGS_LIB_DEBUG% %$DEFS_LIB_DEBUG% %%~G
	)
	ECHO(
	
	
	REM *** Tlib will throw warning if library is already created. So remove it
	REM *** before building. 
	REM
	
	IF EXIST lib\freeglut_staticd.lib DEL lib\freeglut_staticd.lib
	
	PUSHD objs\lib_debug
	"%$BIN%\tlib.exe" ..\..\lib\freeglut_staticd.lib /P32 /a %$OBJ_FILES%, ^
		..\..\lib\freeglut_staticd.lst
	POPD

) ELSE (
	ECHO  SKIPPED.
)


REM	****************************************************************************
REM
REM		Compile release static library.
REM
REM ****************************************************************************


ECHO(
<NUL SET /P $TMP=--- Building of release static library is

IF "%$BUILD_LIB_RELEASE: =%" == "1" (

	ECHO  RUNNING...
	ECHO(


	FOR %%G IN (
		"-nobjs\lib_release\		%$SRC_FILES_ROOT%"
		"-nobjs\lib_release\mswin\	%$SRC_FILES_MSWIN%"
		"-nobjs\lib_release\util\	src\util\xparsegeometry_repl.c"
	) DO (
		"%$BIN%\bcc32.exe" %$CFLAGS_LIB_RELEASE% %$DEFS_LIB_RELEASE% %%~G
	)
	ECHO(


	IF EXIST lib\freeglut_static.lib DEL lib\freeglut_static.lib
	
	PUSHD objs\lib_release
	"%$BIN%\tlib.exe" ..\..\lib\freeglut_static.lib /a %$OBJ_FILES%, ^
		..\..\lib\freeglut_static.lst
	POPD

) ELSE (
	ECHO  SKIPPED.
)


REM	****************************************************************************
REM
REM		Compile debugging DLL.
REM
REM ****************************************************************************


ECHO(
<NUL SET /P $TMP=--- Building of debugging DLL is

IF "%$BUILD_DLL_DEBUG: =%" == "1" (

	ECHO  RUNNING...
	ECHO(


	FOR %%G IN (
		"-nobjs\dll_debug\			%$SRC_FILES_ROOT%"
		"-nobjs\dll_debug\mswin\	%$SRC_FILES_MSWIN%"
		"-nobjs\dll_debug\util\		src\util\xparsegeometry_repl.c"
	) DO (
		"%$BIN%\bcc32.exe" %$CFLAGS_DLL_DEBUG% %$DEFS_DLL_DEBUG% %%~G
	)


	PUSHD objs\dll_debug
	"%$BIN%\ilink32.exe" %$LFLAGS_DLL_DEBUG% -I..\..\dll\ ^
		%$OBJ_FILES% %$DLL_STARTUP_MODULE%, ^
		..\..\dll\freeglutd.dll,, ^
		%$LINKER_LIBS%
	POPD

) ELSE (
	ECHO  SKIPPED.
)


REM	****************************************************************************
REM
REM		Compile release DLL.
REM
REM ****************************************************************************


ECHO(
<NUL SET /P $TMP=--- Building of release DLL is

IF "%$BUILD_DLL_RELEASE: =%" == "1" (

	ECHO  RUNNING...
	ECHO(


	FOR %%G IN (
		"-nobjs\dll_release\		%$SRC_FILES_ROOT%"
		"-nobjs\dll_release\mswin\	%$SRC_FILES_MSWIN%"
		"-nobjs\dll_release\util\	src\util\xparsegeometry_repl.c"
	) DO (
		"%$BIN%\bcc32.exe" %$CFLAGS_DLL_RELEASE% %$DEFS_DLL_RELEASE% %%~G
	)

	
	PUSHD objs\dll_release
	"%$BIN%\ilink32.exe" %$LFLAGS_DLL_RELEASE% -I..\..\dll\ ^
		%$OBJ_FILES% %$DLL_STARTUP_MODULE%, ^
		..\..\dll\freeglut.dll,, ^
		%$LINKER_LIBS%
	POPD

) ELSE (
	ECHO  SKIPPED.
)


REM	****************************************************************************
REM
REM		Compile demo applications' resources and copy assets.
REM
REM ****************************************************************************


SET $BUILD_RES=FALSE
IF "%$BUILD_DEMO_LIB_DEBUG: =%" == "1" SET $BUILD_RES=TRUE
IF "%$BUILD_DEMO_LIB_RELEASE: =%" == "1" SET $BUILD_RES=TRUE
IF "%$BUILD_DEMO_DLL_DEBUG: =%" == "1" SET $BUILD_RES=TRUE
IF "%$BUILD_DEMO_DLL_RELEASE: =%" == "1" SET $BUILD_RES=TRUE


ECHO(
<NUL SET /P $TMP=--- Building of demo applications' resources is

IF %$BUILD_RES% == TRUE (

	ECHO  RUNNING...
	ECHO(


	"%$BIN%\brc32.exe" -r -fores\one.res src\demos\one\one.rc
	ECHO(


	FOR %%G IN (
		fractals\fractals.dat
		fractals_random\fractals.dat
	) DO (
		COPY src\demos\%%G exe\%%G
	)

) ELSE (
	ECHO  SKIPPED.
)


REM	****************************************************************************
REM
REM		Compile debugging demo applications with static library linkage.
REM
REM ****************************************************************************


ECHO(
ECHO --- Building of debugging demo applications with static library linkage
<NUL SET /P $TMP=--- is

IF "%$BUILD_DEMO_LIB_DEBUG: =%" == "1" (

	CALL :BuildDebugDemoApp_Lib

) ELSE (
	ECHO  SKIPPED.
)


REM	****************************************************************************
REM
REM		Compile release demo applications with static library linkage.
REM
REM ****************************************************************************


ECHO(
ECHO --- Building of release demo applications with static library linkage
<NUL SET /P $TMP=--- is

IF "%$BUILD_DEMO_LIB_RELEASE: =%" == "1" (

	CALL :BuildReleaseDemoApp_Lib

) ELSE (
	ECHO  SKIPPED.
)


REM	****************************************************************************
REM
REM		Compile debugging demo applications with DLL.
REM
REM ****************************************************************************


ECHO(
ECHO --- Building of debugging demo applications with dynamic library linkage
<NUL SET /P $TMP=--- is

IF "%$BUILD_DEMO_DLL_DEBUG: =%" == "1" (

	CALL :BuildDebugDemoApp_DLL

) ELSE (
	ECHO  SKIPPED.
)


REM	****************************************************************************
REM
REM		Compile release demo applications with DLL.
REM
REM ****************************************************************************


ECHO(
ECHO --- Building of release demo applications with dynamic library linkage
<NUL SET /P $TMP=--- is

IF "%$BUILD_DEMO_DLL_RELEASE: =%" == "1" (

	CALL :BuildReleaseDemoApp_DLL

) ELSE (
	ECHO  SKIPPED.
)


ECHO(
ECHO --- Building process has been completed.
ECHO(


REM	****************************************************************************
REM
REM		Execution of the script was finished.
REM
REM ****************************************************************************


ENDLOCAL
EXIT /B


REM	****************************************************************************
REM
REM		Functions.
REM
REM ****************************************************************************


:BuildDebugDemoApp_Lib
SETLOCAL

	IF NOT EXIST lib\freeglut_staticd.lib (
		ECHO  ABORTED.
		ECHO(
		ECHO Error: freeglut_staticd.lib was not found in "lib" directory. You
		ECHO        need to build debugging static library at first.
		EXIT /B
	)


	ECHO  RUNNING...
	ECHO(


	"%$BIN%\bcc32.exe" %$CFLAGS_LIB_DEBUG% %$DEFS_LIB_DEBUG% ^
		-nobjs\lib_debug\demos\ %$SRC_FILES_DEMO%


	FOR %%G IN (
		%$DEMO_LINK_OBJ%
	) DO (

		FOR /F "tokens=1-3 delims=;" %%H IN (
			%%G
		) DO (

			REM *** G - parameters for linking.

			REM *** H - name of demo application.
			REM *** I - additional object files for linkage.
			REM *** J - compiled resource files.
	
			"%$BIN%\ilink32.exe" %$LFLAGS_DEMO_DEBUG% -Iexe\%%H\ ^
				-jobjs\lib_debug\demos\ ^
				%%H.obj %%I ^
				%$DEMO_STARTUP_MODULE%, ^
				exe\%%H\%%H_lib_debug.exe,, ^
				%$LINKER_LIBS% ^
				lib\freeglut_staticd.lib,, ^
				%%J
		)
	)

ENDLOCAL
EXIT /B


REM ****************************************************************************
REM ****************************************************************************


:BuildReleaseDemoApp_Lib
SETLOCAL

	IF NOT EXIST lib\freeglut_static.lib (
		ECHO  ABORTED.
		ECHO(
		ECHO Error: freeglut_static.lib was not found in "lib" directory. You
		ECHO        need to build release static library at first.
		EXIT /B
	)


	ECHO  RUNNING...
	ECHO(


	"%$BIN%\bcc32.exe" %$CFLAGS_LIB_RELEASE% %$DEFS_LIB_RELEASE% ^
		-nobjs\lib_release\demos\ %$SRC_FILES_DEMO%


	FOR %%G IN (
		%$DEMO_LINK_OBJ%
	) DO (

		FOR /F "tokens=1-3 delims=;" %%H IN (
			%%G
		) DO (

			"%$BIN%\ilink32.exe" %$LFLAGS_DEMO_RELEASE% -Iexe\%%H\ ^
				-jobjs\lib_release\demos\ ^
				%%H.obj %%I ^
				%$DEMO_STARTUP_MODULE%, ^
				exe\%%H\%%H_lib_release.exe,, ^
				%$LINKER_LIBS% ^
				lib\freeglut_static.lib,, ^
				%%J
		)
	)
ENDLOCAL
EXIT /B


REM ****************************************************************************
REM ****************************************************************************


:BuildDebugDemoApp_DLL
SETLOCAL

	IF NOT EXIST dll\freeglutd.lib (
		ECHO  ABORTED.
		ECHO(
		ECHO Error: freeglutd.lib was not found in "dll" directory. You need to
		ECHO        build debugging dynamic-link library at first.
		EXIT /B
	)


	ECHO  RUNNING...
	ECHO(


	"%$BIN%\bcc32.exe" %$CFLAGS_DLL_DEBUG% %$DEFS_DLL_DEBUG% ^
		-nobjs\dll_debug\demos\ %$SRC_FILES_DEMO%
	ECHO(


	FOR %%G IN (
		%$DEMO_LINK_OBJ%
	) DO (

		FOR /F "tokens=1-3 delims=;" %%H IN (
			%%G
		) DO (
	
			"%$BIN%\ilink32.exe" %$LFLAGS_DEMO_DEBUG% -Iexe\%%H\ ^
				-jobjs\dll_debug\demos\ ^
				%%H.obj %%I ^
				%$DEMO_STARTUP_MODULE%, ^
				exe\%%H\%%H_dll_debug.exe,, ^
				%$LINKER_LIBS% ^
				dll\freeglutd.lib,, ^
				%%J
		)
	)
ENDLOCAL
EXIT /B


REM ****************************************************************************
REM ****************************************************************************


:BuildReleaseDemoApp_DLL
SETLOCAL

	IF NOT EXIST dll\freeglut.lib (
		ECHO  ABORTED.
		ECHO(
		ECHO Error: freeglut.lib was not found in "dll" directory. You need to
		ECHO        build release dynamic-link library at first.
		EXIT /B
	)


	ECHO  RUNNING...
	ECHO(


	"%$BIN%\bcc32.exe" %$CFLAGS_DLL_RELEASE% %$DEFS_DLL_RELEASE% ^
		-nobjs\dll_release\demos\ %$SRC_FILES_DEMO%
	ECHO(


	FOR %%G IN (
		%$DEMO_LINK_OBJ%
	) DO (

		FOR /F "tokens=1-3 delims=;" %%H IN (
			%%G
		) DO (

			"%$BIN%\ilink32.exe" %$LFLAGS_DEMO_RELEASE% -Iexe\%%H\ ^
				-jobjs\dll_release\demos\ ^
				%%H.obj %%I ^
				%$DEMO_STARTUP_MODULE%, ^
				exe\%%H\%%H_dll_release.exe,, ^
				%$LINKER_LIBS% ^
				dll\freeglut.lib,, ^
				%%J
		)
	)
ENDLOCAL
EXIT /B

