
@ECHO OFF
SETLOCAL


REM		Remove previously compiled objects and intermediate compiling files
REM		(libraries and executables stay untouched).
REM
REM		Copyright (c) 2024 skipper
REM		http://www.heroesden.link


ECHO(
ECHO --- Removing compiled object files, intermediate files and compiled
ECHO --- resources generated by last compiling process...
ECHO(


REM	****************************************************************************
REM
REM		Remove intermediate files of last compiling from "dll" folder.
REM
REM ****************************************************************************


FOR %%G IN (
	freeglut
	freeglutd
) DO (

	FOR %%H IN (
		map
		tds
		ilc
		ild
		ilf
		ils
	) DO (
		IF EXIST dll\%%G.%%H DEL dll\%%G.%%H
	)
)


REM	****************************************************************************
REM
REM		Remove intermediate files of last compiling from "exe" folder.
REM
REM ****************************************************************************


FOR %%G IN (
	3dview
	callback_maker
	fractals
	fractals_random
	indexed_color
	init_error_func
	joystick
	keyboard
	lorenz
	multi_touch
	one
	resizer
	shapes
	smooth_opengl3
	spaceball
	subwin
	timer
	timer_callback
) DO (

	FOR %%H IN (
		lib_debug
		lib_release
		dll_debug
		dll_release
	) DO (

		FOR %%I IN (
			map
			tds
			ilc
			ild
			ilf
			ils
		) DO (
			IF EXIST exe\%%G\%%G_%%H.%%I DEL exe\%%G\%%G_%%H.%%I
		)
	)

	FOR %%H IN (
		OGLdpf.log
	) DO (
		IF EXIST exe\%%G\%%H DEL exe\%%G\%%H
	)
)


REM	****************************************************************************
REM
REM		Remove intermediate files of last compiling from "lib" folder.
REM
REM ****************************************************************************


FOR %%G IN (
	freeglut_static
	freeglut_staticd
) DO (

	FOR %%H IN (
		lst
		bak
	) DO (
		IF EXIST lib\%%G.%%H DEL lib\%%G.%%H
	)
)


REM	****************************************************************************
REM
REM		Remove object files from "objs" folder.
REM
REM ****************************************************************************


FOR %%G IN (
	objs\lib_debug
	objs\lib_release
	objs\dll_debug
	objs\dll_release
) DO (

	FOR %%H IN (
		fg_callbacks.obj
		fg_cursor.obj
		fg_display.obj
		fg_ext.obj
		fg_font.obj
		fg_font_data.obj
		fg_gamemode.obj
		fg_geometry.obj
		fg_gl2.obj
		fg_init.obj
		fg_input_devices.obj
		fg_joystick.obj
		fg_main.obj
		fg_menu.obj
		fg_misc.obj
		fg_overlay.obj
		fg_spaceball.obj
		fg_state.obj
		fg_stroke_mono_roman.obj
		fg_stroke_roman.obj
		fg_structure.obj
		fg_teapot.obj
		fg_videoresize.obj
		fg_window.obj
		mswin\fg_cmap_mswin.obj
		mswin\fg_cursor_mswin.obj
		mswin\fg_display_mswin.obj
		mswin\fg_ext_mswin.obj
		mswin\fg_gamemode_mswin.obj
		mswin\fg_init_mswin.obj
		mswin\fg_input_devices_mswin.obj
		mswin\fg_joystick_mswin.obj
		mswin\fg_main_mswin.obj
		mswin\fg_menu_mswin.obj
		mswin\fg_spaceball_mswin.obj
		mswin\fg_state_mswin.obj
		mswin\fg_structure_mswin.obj
		mswin\fg_window_mswin.obj
		util\xparsegeometry_repl.obj
		demos\3dview.obj
		demos\callback_maker.obj
		demos\fractals.obj
		demos\fractals_random.obj
		demos\indexed_color.obj
		demos\init_error_func.obj
		demos\joystick.obj
		demos\keyboard.obj
		demos\lorenz.obj
		demos\multi_touch.obj
		demos\one.obj
		demos\resizer.obj
		demos\shapes.obj
		demos\glmatrix.obj
		demos\smooth_opengl3.obj
		demos\spaceball.obj
		demos\vmath.obj
		demos\subwin.obj
		demos\timer.obj
		demos\timer_callback.obj
	) DO (
		IF EXIST %%G\%%H DEL %%G\%%H
	)
)


REM	****************************************************************************
REM
REM		Remove old compiled resource files from "res" folder.
REM
REM ****************************************************************************


FOR %%G IN (
	one.res
) DO (
	IF EXIST res\%%G DEL res\%%G
)


REM	****************************************************************************
REM
REM		Execution of the script was finished.
REM
REM ****************************************************************************


ENDLOCAL

