
@ECHO OFF
SETLOCAL


REM		Remove all files generated by compiling process including object
REM		files, intermediate files, static and dynamic libraries and
REM		executables.
REM
REM		Copyright (c) 2024 skipper
REM		http://www.heroesden.link


REM ****************************************************************************
REM
REM		Firstly remove compiled object files and intermediate files of a last
REM		compiling process.
REM
REM ****************************************************************************


CALL clean.bat


ECHO(
ECHO --- Removing compiled static libraries, demo applications with assets and
ECHO --- dynamic libraries...
ECHO(


REM ****************************************************************************
REM
REM		Remove compiled dynamic libraries from "dll" folder.
REM
REM ****************************************************************************


FOR %%G IN (
	freeglut
	freeglutd
) DO (

	FOR %%H IN (
		dll
		lib
	) DO (
		IF EXIST dll\%%G.%%H DEL dll\%%G.%%H
	)
)


REM ****************************************************************************
REM
REM		Remove compiled demo applications and assets from "exe" folder.
REM
REM ****************************************************************************


FOR %%G IN (
	3dview
	callback_maker
	fractals
	fractals_random
	indexed_color
	init_error_func
	joystick
	keyboard
	lorenz
	multi_touch
	one
	resizer
	shapes
	smooth_opengl3
	spaceball
	subwin
	timer
	timer_callback
) DO (

	FOR %%H IN (
		lib_debug
		lib_release
		dll_debug
		dll_release
	) DO (
		IF EXIST exe\%%G\%%G_%%H.exe DEL exe\%%G\%%G_%%H.exe
	)
)


FOR %%G IN (
	fractals\fractals.dat
	fractals_random\fractals.dat
) DO (
	IF EXIST exe\%%G DEL exe\%%G
	)
)


REM ****************************************************************************
REM
REM		Remove compiled static libraries from "lib" folder.
REM
REM ****************************************************************************


FOR %%G IN (
	freeglut_static
	freeglut_staticd
) DO (
	IF EXIST lib\%%G.lib DEL lib\%%G.lib
)


REM	****************************************************************************
REM
REM		Execution of the script was finished.
REM
REM ****************************************************************************


ENDLOCAL

