
@ECHO OFF
SETLOCAL


REM		Create missed directories where compiling files will be placed.
REM
REM		Copyright (c) 2024 skipper
REM		http://www.heroesden.link


ECHO(
ECHO --- Creating missed folders...
ECHO(


REM	****************************************************************************
REM
REM		Create root folders.
REM
REM ****************************************************************************


FOR %%G IN (
	dll
	exe
	lib
	objs
	res
) DO (
	IF NOT EXIST %%G\ MKDIR %%G
)


REM	****************************************************************************
REM
REM		Create subfolders in "exe" folder.
REM
REM ****************************************************************************


FOR %%G IN (
	3dview
	callback_maker
	fractals
	fractals_random
	indexed_color
	init_error_func
	joystick
	keyboard
	lorenz
	multi_touch
	one
	resizer
	shapes
	smooth_opengl3
	spaceball
	subwin
	timer
	timer_callback
) DO (
	IF NOT EXIST exe\%%G\ MKDIR exe\%%G
)


REM	****************************************************************************
REM
REM		Create subfolders in "objs" folder.
REM
REM ****************************************************************************


FOR %%G IN (
	objs\lib_debug
	objs\lib_release
	objs\dll_debug
	objs\dll_release
) DO (

	IF NOT EXIST %%G\ MKDIR %%G

	FOR %%H IN (
		mswin
		util
		demos
	) DO (
		IF NOT EXIST %%G\%%H\ MKDIR %%G\%%H
	)
)


REM	****************************************************************************
REM
REM		Execution of the script was finished.
REM
REM ****************************************************************************


ENDLOCAL

