
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char *argv[])
{
	/***************************************************************************
	*
	*	Variables.
	*
	***************************************************************************/


	char *srcPath;

	//	In Windows API the maximum length for a path is 260 characters.
	//
	char dstPath[260];

	FILE *pFile;
	size_t lSize;
	char *buffer;
	size_t result;


	/***************************************************************************
	*
	*	Open a source file.
	*
	***************************************************************************/


	//	Does the user specified a file for conversion?
	//
	if(argc < 2)
	{
		puts("Error. No input files specified.");
		return 0;
	}

	//	Try to open the file.
	//
	srcPath = argv[1];

	if(strlen(srcPath) >= sizeof(dstPath))
	{
		puts("Error. Length of source file path is too big.");
		return 0;
	}

	pFile = fopen(srcPath, "r");

	if(pFile == NULL)
	{
		perror("Error opening the source file");
		return 0;
	}

	//	Calculate size of the source file.
	//
	fseek(pFile, 0, SEEK_END);
	lSize = ftell(pFile);
	rewind(pFile);

	//	Allocate memory for the file content.
	//
	buffer = (char*) malloc (sizeof(char) * lSize);
	if(buffer == NULL)
	{
		puts("Error. Can't allocate dynamic memory.");
		return 0;
	}

	//	Copy the file content into the buffer.
	//
	result = fread(buffer, sizeof(char), lSize, pFile);
	if(result != lSize)
	{
		puts("Error. Can't read the file content.");
		return 0;
	}

	//	The source file is not need more.
	//
	fclose(pFile);


	/***************************************************************************
	*
	*	Make replacements.
	*
	***************************************************************************/



	/***************************************************************************
	*
	*	Write the modified file.
	*
	***************************************************************************/


	{
		//	Find dot's position in the source file path.
		//
		char *pCh;
		size_t length;
		size_t bufSize;

		pCh = strrchr(srcPath, '.');
		if(pCh == NULL)
		{
			puts("Error. Can't find dot in source file path.");
			return 0;
		}

		//	Copy source file path without '.sal' extension to destination file
		//	path and append '.c' to the end.
		//
		length = pCh - srcPath + 1;
		memcpy(dstPath, srcPath, length);

		dstPath[length] = 'c';
		dstPath[length + 1] = '\0';

		//	Create new file and write modified source code into it.
		//
		pFile = fopen(dstPath, "w");

		if(pFile == NULL)
		{
			perror("Error opening the destination file");
			return 0;
		}

		bufSize = strlen(buffer) + 1;
		result = fwrite(buffer, sizeof(char), bufSize, pFile);

		if(result != bufSize)
		{
			puts("Error. Can't write the buffer to the destination file.");
			return 0;
		}
	
		//	The source file is not need more.
		//
		fclose(pFile);
	}
	

	free(buffer);
	puts("Congrutalations! All is file.");
	return 0;
}

